﻿$(document).ready(function() {
   $("#liMyItineraries a").bind("mouseover", showMyItineraries);
   $("#liMyItineraries a").bind("click", function(e) { e.preventDefault(); });
});

var myItineraryHideDelay = 0;

function showMyItineraries() {
    clearTimeout(myItineraryHideDelay);
    
    if ($("#myItinerariesBox").length == 1) {
        $("#myItinerariesBox").slideDown();
    } else {
        // create
        var box = $('<div id="myItinerariesBox"><ul class="loading"></ul></div>');
        $("#liMyItineraries").append(box);
        box.slideDown();

        // get data
        var url = baseUrl + "Itineraries";
        $.ajax({
            url: url,
            method: "GET",
            type: this.method,
            dataType: "json",
            beforeSend: function (xhr) { xhr.setRequestHeader("Content-Type", "application/json"); },
            success: function (json) {
                var list = $("#myItinerariesBox ul");
                if (json.Status && json.Status == "error") {
                    var li = $("<li><strong>Ooos! An error has occurred.</strong><br />Please <a href='" + json.RetryUrl + "'>try again</a></li>");
                    li.find("a").bind("click", function () {
                        $("#myItinerariesBox").remove();
                        toggleMyItineraries();
                        return false;
                    });
                    li.appendTo(list);
                } else if (json.Itineraries.length == 0) {
                    var li = $("<li><strong>You do not have any saved itineraries.</strong></li>");
                    li.appendTo(list);
                } else {
                    for (var i = 0; i < json.Itineraries.length; i++) {
                        var itinerary = json.Itineraries[i];
                        var a = $("<a></a>");
                        a.attr("href", itinerary.DetailsLink);
                        a.attr("title", itinerary.Description);
                        a.append(itinerary.Name);
                        var isPublic = itinerary.IsPublic;
                        var img = $('<img src="' + baseUrl + 'Content/Images/myitineraries_icon_' + (isPublic ? 'public' : 'private') + '.png" alt="' + (isPublic ? 'Public itinerary' : 'Private itinerary') + '" />');
                        var li = $("<li></li>");
                        li.append(img).append(a).appendTo(list);
                    }
                }

                list.removeClass("loading");
                
                var hideFunc = function() {
                    clearInterval(myItineraryHideDelay);
                    myItineraryHideDelay = setTimeout(function() { $("#myItinerariesBox").slideUp(); }, 150);
                };
                var cancelHideFunc = function() { clearInterval(myItineraryHideDelay); };
                
                $("#myItinerariesBox, #liMyItineraries a").bind("mouseout", hideFunc);
                $("#myItinerariesBox, #liMyItineraries a").bind("mouseover", cancelHideFunc);
            }
        });
    }
}
